/*
 * Decompiled with CFR 0.152.
 */
package dev.quantumfusion.dashloader.thread;

import dev.quantumfusion.dashloader.thread.ThreadHandler;
import java.util.concurrent.RecursiveAction;
import java.util.function.Function;

public final class ArrayMapTask<I, O>
extends RecursiveAction {
    private final int threshold;
    private final int start;
    private final int stop;
    private final I[] inArray;
    private final O[] outArray;
    private final Function<I, O> function;

    private ArrayMapTask(I[] inArray, O[] outArray, Function<I, O> function, int threshold, int start, int stop) {
        this.threshold = threshold;
        this.start = start;
        this.stop = stop;
        this.inArray = inArray;
        this.outArray = outArray;
        this.function = function;
    }

    public ArrayMapTask(I[] inArray, O[] outArray, Function<I, O> function) {
        this.start = 0;
        this.stop = inArray.length;
        this.threshold = ThreadHandler.calcThreshold(this.stop);
        this.inArray = inArray;
        this.outArray = outArray;
        this.function = function;
    }

    @Override
    protected void compute() {
        int size = this.stop - this.start;
        if (size < this.threshold) {
            for (int i = this.start; i < this.stop; ++i) {
                this.outArray[i] = this.function.apply(this.inArray[i]);
            }
        } else {
            int middle = this.start + size / 2;
            ArrayMapTask.invokeAll(new ArrayMapTask<I, O>(this.inArray, this.outArray, this.function, this.threshold, this.start, middle), new ArrayMapTask<I, O>(this.inArray, this.outArray, this.function, this.threshold, middle, this.stop));
        }
    }
}

